using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgMsbos
	/// </summary>
	public class DlgMsbos : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		/// <summary>
		/// InappropriateRequest
		/// </summary>
		public bool InappropriateRequest;

		private BOL.Msbos _msbos;
		private BOL.MsbosComponentClass _msbosComponentClass;
		private DataSet _msbosComponents;
		private DataRow _selectedMSBOS;
		private DataRow _selectedComponentClass;
		private DataTable _orderableComponentClasses;

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TreeView tvExistingMSBOS;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpSurgicalProcedure;
		private System.Windows.Forms.GroupBox grpMSBOS;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.CheckBox cbInappropriateRequest;
		private System.Windows.Forms.TextBox txtProcedure;
		private System.ComponentModel.IContainer components = null;

		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="surgeryName"></param>
		/// <param name="inappropriateRequestIndicator"></param>
		public DlgMsbos(string surgeryName, bool inappropriateRequestIndicator)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
            
			SetComponentProperties(inappropriateRequestIndicator);

			this._msbos = new BOL.Msbos();
			this._msbosComponents = this._msbos.GetMsbosEntries();
			DataRelation msbosRel = new DataRelation("MSBOSComponents",_msbosComponents.Tables[0].Columns["MsbosGuid"],_msbosComponents.Tables[1].Columns["MsbosGuid"]);
			this._msbosComponents.Relations.Add(msbosRel);
			this._orderableComponentClasses = this._msbos.GetOrderableComponentClasses();

			LoadMSBOSEntries();
			this.txtProcedure.Text = surgeryName;
		}

		#endregion


		#region properties

		/// <summary>
		/// Get CheckState
		/// </summary>
		public bool CheckState
		{
			get
			{
				return this.cbInappropriateRequest.Checked;
			}
		}

		#endregion


		#region methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgMsbos));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpSurgicalProcedure = new System.Windows.Forms.GroupBox();
			this.txtProcedure = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.grpMSBOS = new System.Windows.Forms.GroupBox();
			this.cbInappropriateRequest = new System.Windows.Forms.CheckBox();
			this.tvExistingMSBOS = new System.Windows.Forms.TreeView();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage.SuspendLayout();
			this.grpSurgicalProcedure.SuspendLayout();
			this.grpMSBOS.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(384, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Maximum Surgical Blood Order Schedule";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 337);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 285);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpSurgicalProcedure
			// 
			this.grpSurgicalProcedure.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSurgicalProcedure.Controls.Add(this.txtProcedure);
			this.grpSurgicalProcedure.Controls.Add(this.label1);
			this.grpSurgicalProcedure.Location = new System.Drawing.Point(64, 32);
			this.grpSurgicalProcedure.Name = "grpSurgicalProcedure";
			this.grpSurgicalProcedure.Size = new System.Drawing.Size(316, 40);
			this.grpSurgicalProcedure.TabIndex = 3;
			this.grpSurgicalProcedure.TabStop = false;
			// 
			// txtProcedure
			// 
			this.txtProcedure.AccessibleDescription = "Surgical Procedure";
			this.txtProcedure.AccessibleName = "Surgical Procedure";
			this.txtProcedure.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProcedure.Location = new System.Drawing.Point(112, 12);
			this.txtProcedure.Name = "txtProcedure";
			this.txtProcedure.ReadOnly = true;
			this.txtProcedure.Size = new System.Drawing.Size(196, 20);
			this.txtProcedure.TabIndex = 1;
			this.txtProcedure.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 12);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(104, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "Surgical Procedure";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpMSBOS
			// 
			this.grpMSBOS.AccessibleDescription = "Select MSBOS";
			this.grpMSBOS.AccessibleName = "Select MSBOS";
			this.grpMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMSBOS.Controls.Add(this.cbInappropriateRequest);
			this.grpMSBOS.Controls.Add(this.tvExistingMSBOS);
			this.grpMSBOS.Location = new System.Drawing.Point(64, 76);
			this.grpMSBOS.Name = "grpMSBOS";
			this.grpMSBOS.Size = new System.Drawing.Size(316, 241);
			this.grpMSBOS.TabIndex = 0;
			this.grpMSBOS.TabStop = false;
			this.grpMSBOS.Text = "Select MSBOS*";
			// 
			// cbInappropriateRequest
			// 
			this.cbInappropriateRequest.AccessibleDescription = "Include in Inappropriate Transfusion Request report?";
			this.cbInappropriateRequest.AccessibleName = "Include in Inappropriate Transfusion Request report?";
			this.cbInappropriateRequest.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbInappropriateRequest.Location = new System.Drawing.Point(8, 217);
			this.cbInappropriateRequest.Name = "cbInappropriateRequest";
			this.cbInappropriateRequest.Size = new System.Drawing.Size(300, 20);
			this.cbInappropriateRequest.TabIndex = 1;
			this.cbInappropriateRequest.Text = "&Include in Inappropriate Transfusion Request report?";
			this.cbInappropriateRequest.CheckStateChanged += new System.EventHandler(this.cbInappropriateRequest_CheckStateChanged);
			// 
			// tvExistingMSBOS
			// 
			this.tvExistingMSBOS.AccessibleDescription = "Select MSBOS";
			this.tvExistingMSBOS.AccessibleName = "Select MSBOS";
			this.tvExistingMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tvExistingMSBOS.ImageList = this.imageList1;
			this.tvExistingMSBOS.Location = new System.Drawing.Point(8, 16);
			this.tvExistingMSBOS.Name = "tvExistingMSBOS";
			this.tvExistingMSBOS.Size = new System.Drawing.Size(302, 201);
			this.tvExistingMSBOS.TabIndex = 0;
			this.tvExistingMSBOS.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvExistingMSBOS_AfterSelect);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(304, 321);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(224, 321);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// DlgMsbos
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(384, 353);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpSurgicalProcedure);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpMSBOS);
			this.hlphelpChm.SetHelpKeyword(this, "Accept_Orders.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(392, 380);
			this.Name = "DlgMsbos";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "Maximum Surgical Blood Order Schedule";
			this.Controls.SetChildIndex(this.grpMSBOS, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpSurgicalProcedure, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpSurgicalProcedure.ResumeLayout(false);
			this.grpMSBOS.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties(bool inappropriateRequestIndicator)
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC016.DlgMsbos());
			this.tvExistingMSBOS.Nodes.Clear();
			this.cbInappropriateRequest.Checked = inappropriateRequestIndicator;
		}

		private void LoadMSBOSEntries()
		{
			DataTable dtComponents = _msbosComponents.Tables[1];
			foreach(DataRow drMSBOS in _msbosComponents.Tables[0].Rows)
			{
				this._selectedMSBOS = drMSBOS;
				this._msbos = new BOL.Msbos(this._selectedMSBOS);
				string filterStr = Common.VbecsTables.Msbos.MsbosGuid + " = '"+this._msbos.MsbosGuid.ToString()+"'";
				this._msbos.BloodComponentClasses = dtComponents.Select(filterStr);
				//Only display active MSBOS entries
				if (this._msbos.RecordStatusCode == Common.RecordStatusCode.Active)
				{
					AddMSBOSNode();
					//Only display components if not type and screen
					//or No Blood required
					if ((!_msbos.IsTypeAndScreen)&&(!_msbos.IsNoBloodRequired))
					{
						foreach (DataRow drClass in this._msbos.BloodComponentClasses)
						{
							this._selectedComponentClass = drClass;
							this._msbosComponentClass = new BOL.MsbosComponentClass(this._selectedComponentClass);
							//Only display active MSBOS Component Class entries
							if (this._msbosComponentClass.RecordStatusCode == Common.RecordStatusCode.Active)
							{
								AddComponentClassNode();
							}
						}
					}
				}
			}
		}

		private void AddComponentClassNode()
		{
			//
			int parentIndex;
			//
			foreach(TreeNode node in this.tvExistingMSBOS.Nodes)
			{
				DataRow dr = (DataRow)node.Tag;
				if (dr.Equals(_selectedMSBOS))
				{
					parentIndex = node.Index;
					//
					ComponentClassTreeNode componentNode = new ComponentClassTreeNode();
					componentNode.Tag = this._selectedComponentClass;
					componentNode.Text = this._msbosComponentClass.MaximumSetupUnitQuantity.ToString() + " " + this._msbosComponentClass.ComponentClassName;
					this.tvExistingMSBOS.Nodes[parentIndex].Nodes.Add(componentNode);
					componentNode.EnsureVisible();		
					//
					break;
				}
			}
		}

		private void AddMSBOSNode()
		{
			MsbosTreeNode msbosNode = new MsbosTreeNode();
			msbosNode.Tag = this._selectedMSBOS;
			msbosNode.Text = this._msbos.SurgeryName;
			if (this._msbos.IsTypeAndScreen)
			{
				msbosNode.Text = msbosNode.Text + " -- TYPE & SCREEN";
			}
			if (this._msbos.IsNoBloodRequired)
			{
				msbosNode.Text = msbosNode.Text + " -- NO BLOOD REQUIRED";
			}
			msbosNode.Active = (this._msbos.RecordStatusCode == Common.RecordStatusCode.Active);
			this.tvExistingMSBOS.Nodes.Add(msbosNode);
			msbosNode.EnsureVisible();
		}

		#endregion


		#region events

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (this.cbInappropriateRequest.Checked == true)
			{
				this.InappropriateRequest = true;
			}
			this.AcceptButton.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void tvExistingMSBOS_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
				
		}

		private void cbInappropriateRequest_CheckStateChanged(object sender, System.EventArgs e)
		{
		
		}

		#endregion	
		
	}
}

